#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Moving layersMod01.fsh    by    LizardLover42  
//https://www.shadertoy.com/view/WcVSDm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 resolution = iResolution.xy;
    vec2 uv = fragCoord.xy / resolution.xy;
    float aspect = resolution.x / resolution.y;
    vec2 p = vec2(uv.x-0.004 * aspect, uv.y);


 //   p = p * 2.0 - 2.0;
    p = p * 2.2 - 1.1;

    float time = iTime * 0.3;


    float layers = 7.0;
    float depth = 0.1;
    for (float i = 0.0; i < layers; i++)
    {
        float layerDepth = i / layers;
        float scale = 1.0 - layerDepth * 0.6;
        float layerTimeOffset = i * 0.3 + time;

        vec2 layerP = p * scale;
        float dist = length(layerP);

        float distortionX = sin(layerP.x * 12.0 + layerTimeOffset * 2.5) * 0.15 * (1.0 - layerDepth);
        float distortionY = cos(layerP.y * 12.0 + layerTimeOffset * 3.5) * 0.15 * (1.0 - layerDepth);
        dist += distortionX + distortionY;

        float ringWidth = 0.01 + layerDepth * 0.02;
        float ring = smoothstep(dist - ringWidth, dist, 0.5) - smoothstep(dist, dist + ringWidth, 0.5);
        depth += ring * (1.0 - layerDepth * 0.3);
    }

    vec3 baseColor = vec3(0.9, 0.7, 0.4);
    vec3 lightColor = vec3(1.0, 0.95, 0.8);
    vec3 darkColor = vec3(0.05, 0.02, 0.0);


    vec3 normal = normalize(vec3(p, 0.5));
    vec3 lightDir1 = normalize(vec3(0.5, -0.5, -1.0));
    vec3 lightDir2 = normalize(vec3(-0.3, 0.8, -0.7));
    float diffuse1 = max(0.0, dot(normal, -lightDir1));
    float diffuse2 = max(0.0, dot(normal, -lightDir2));
    float diffuse = (diffuse1 + diffuse2) * 0.5;
    vec3 color = mix(darkColor, mix(baseColor, lightColor, diffuse), depth);


    color += vec3(0.1 * depth, -0.1 * depth, 0.0);

    fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

